#include <algorithm>
#include <iostream>
#include <sstream>
#include <vector>
#include <string>
#include <set>
#include <map>
#include <iterator>
#include <cmath>
#include <cstdlib>
#include <cstdio>
#include <cstring>
#include <cctype>
#include <queue>

using namespace std;

#define FOR(i, a, b) for (LL i = (a); i < (b); ++i)
#define ROF(i, a, b) for (LL i = (b) - 1; i >= (a); --i)

typedef long long LL;
typedef LL ll;
typedef pair <LL, LL> pii;


const LL INF = 10000000000000LL;
const LL LINF = (LL) INF * (LL) INF;

const LL MAXN = 32768;
const LL kN = 20 * 1000;
const LL kInf = INF;

vector<LL> g[kN];
vector<LL> path[kN];
vector<LL> f[kN];

struct Edge {
  LL from, to, w, id;

  Edge(LL from_ = 0, LL to_ = 0, LL w_ = 0, LL id_ = 0) : from(from_), to(to_), w(w_), id(id_) {}
};

vector<Edge> edges;

void Dijkstra(LL n) {
  vector<LL> dist(n, kInf);
  dist[0] = 0;
  priority_queue<pii> pq;
  pq.push(pii(0, 0));
  while (!pq.empty()) {
    auto p = pq.top();
    pq.pop();
    if (dist[p.second] != -p.first) {
      continue;
    }
    LL u = p.second;
    LL d = -p.first;
    for (LL i = 0; i < g[u].size(); ++i) {
      Edge edge = edges[g[u][i]];
      LL v = edge.to;
      LL w = edge.w;
      if (d + w < dist[v]) {
        path[v].clear();
        path[v].push_back(g[u][i]);
        dist[v] = d + w;
        pq.push(pii(-dist[v], v));
      } else if (d + w == dist[v]) {
        path[v].push_back(g[u][i]);
      } 
    }
  }
}

vector<LL> tin;
vector<LL> fup;
vector<char> used;
LL timer = 0;

map<pii, LL> cnt;
LL res = 0;
LL finish;
set <LL> answer;

bool DFS(LL v, LL parent) {
  used[v] = true;
  tin[v] = timer++;
  fup[v] = tin[v];
  bool ok = v == finish;
  for (LL i = 0; i < f[v].size(); ++i) {
    Edge edge = edges[f[v][i]];
    LL to = edge.to;
    if (!used[to]) {
      bool curr = DFS(to, edge.id);
      if (curr) {
        ok = true;
      }
      fup[v] = min(fup[v], fup[to]);
      if (fup[to] > tin[v] && curr) {
        answer.insert(edge.id);
      }
    } else if (edge.id != parent) {
      fup[v] = min(fup[v], tin[to]);
    }
  }
  return ok;
}

int main() {
  std::ios_base::sync_with_stdio(false);
  LL n, m;
  cin >> n >> m;
  finish = n - 1;
  for (LL i = 0; i < m; ++i) {
    LL u, v, w;
    cin >> u >> v >> w; --u; --v;
    edges.push_back(Edge(u, v, w, i + 1));
    g[u].push_back((LL)edges.size() - 1);
    edges.push_back(Edge(v, u, w, i + 1));
    g[v].push_back((LL)edges.size() - 1);
  }
  Dijkstra(n);
  for (LL u = 0; u < n; ++u) {
    for (LL i = 0; i < path[u].size(); ++i) {
      Edge edge = edges[path[u][i]];
      f[edge.from].push_back(path[u][i]);
      f[u].push_back(path[u][i] ^ 1);
    }
  }
  tin.resize(n);
  fup.resize(n);
  used.resize(n);
  DFS(0, -1);

  cout << answer.size() << '\n';
  for (auto it = answer.begin(); it != answer.end(); ++it) {
    cout << *it << ' ';
  }

  return 0;
}